package immibis.core.net;

import immibis.core.NonSharedProxy;
import immibis.core.porting.PortableContainer;
import java.util.Iterator;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ICrafting;
import net.minecraft.server.IInventory;

public abstract class AbstractSyncedContainer extends PortableContainer implements ISyncedContainer
{
    public AbstractSyncedContainer(EntityHuman var1, IInventory var2)
    {
        super(var1, var2);
    }

    public void sendUpdatePacket(IPacket var1)
    {
        if (NonSharedProxy.CLIENT)
        {
            if (!NonSharedProxy.isSSP())
            {
                throw new IllegalStateException("Cannot send update packets from the client");
            }
        }
        else
        {
            String var2 = this.getChannel();
            Iterator var3 = this.listeners.iterator();

            while (var3.hasNext())
            {
                ICrafting var4 = (ICrafting)var3.next();

                if (var4 instanceof EntityHuman)
                {
                    OneTwoFiveNetworking.send(var2, var1, (EntityHuman)var4);
                }
            }
        }
    }

    public void sendActionPacket(IPacket var1)
    {
        if (NonSharedProxy.SERVER)
        {
            throw new IllegalStateException("Cannot send action packets from the server");
        }
        else
        {
            if (NonSharedProxy.isSSP())
            {
                this.onActionPacket(var1);
            }
            else
            {
                OneTwoFiveNetworking.send(this.getChannel(), var1, (EntityHuman)null);
            }
        }
    }

    public abstract String getChannel();

    public void onActionPacket(IPacket var1) {}

    public void onUpdatePacket(IPacket var1) {}

    public void onButtonPressed(int var1) {}

    public void sendButtonPressed(int var1)
    {
        if (NonSharedProxy.SERVER)
        {
            throw new IllegalStateException("Cannot send action packets from the server");
        }
        else
        {
            if (NonSharedProxy.isSSP())
            {
                this.onButtonPressed(var1);
            }
            else
            {
                OneTwoFiveNetworking.send("Immibis1.2.5-GUI", new PacketButtonPress(var1), (EntityHuman)null);
            }
        }
    }

    public final void onReceivePacket(IPacket var1)
    {
        if (NonSharedProxy.SERVER)
        {
            if (var1 instanceof PacketButtonPress)
            {
                this.onButtonPressed(((PacketButtonPress)var1).buttonID);
            }
            else
            {
                this.onActionPacket(var1);
            }
        }
        else
        {
            this.onUpdatePacket(var1);
        }
    }
}
