package immibis.core;

import java.util.LinkedList;
import java.util.List;

import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;

public abstract class NullInventory implements IInventory
{
	@Override
	public ItemStack[] getContents() {
		return new ItemStack[0];
	}

	@Override
	public InventoryHolder getOwner() {
		return new InventoryHolder() {
			@Override
			public Inventory getInventory() {
				return new CraftInventory(NullInventory.this);
			}
		};
	}
	
	private List<HumanEntity> viewers = new LinkedList<HumanEntity>();

	@Override
	public List<HumanEntity> getViewers() {
		return viewers;
	}

	@Override
	public void onClose(CraftHumanEntity arg0) {
		viewers.remove(arg0);
	}

	@Override
	public void onOpen(CraftHumanEntity arg0) {
		viewers.add(arg0);
	}

	@Override
	public void setMaxStackSize(int arg0) {
	}
	
    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return 0;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return null;
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        return null;
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2) {}

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 64;
    }

    /**
     * Called when an the contents of an Inventory change, usually
     */
    public void update() {}

    public void f() {}

    public void g() {}
}
