package immibis.core;

import forge.ITextureProvider;
import java.util.ArrayList;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;

public class BlockMultiTile extends BlockContainer implements ITextureProvider
{
    public static int model;
    static int normalModel;
    int[] textures = new int[6];
    private String texfile;

    protected BlockMultiTile(int var1, Material var2, String var3)
    {
        super(var1, var2);
        this.texfile = var3;
        this.c(2.0F);
    }

    /**
     * Is this block (a) opaque and (b) a full 1m cube?  This determines whether or not to render the shared face of two
     * adjacent blocks and also whether the player can attach torches, redstone wire, etc to this block.
     */
    public boolean a()
    {
        return false;
    }

    /**
     * If this block doesn't render as an ordinary block it will return False (examples: signs, buttons, stairs, etc)
     */
    public boolean b()
    {
        return false;
    }

    public void addCreativeItems(ArrayList var1)
    {
        ItemBlockMultiTile var2 = (ItemBlockMultiTile)Item.byId[this.id];

        for (int var3 = 0; var3 < var2.max_meta; ++var3)
        {
            var1.add(new ItemStack(this, 1, var3));
        }
    }

    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
    public int a(int var1, int var2)
    {
        return this.textures[var1];
    }

    /**
     * The type of render function that is called for this block
     */
    public int c()
    {
        return model;
    }

    /**
     * Returns the TileEntity used by this block.
     */
    public TileEntity a_()
    {
        return null;
    }

    public String getTextureFile()
    {
        return this.texfile;
    }
}
