package immibis.chunkloader;

import immibis.core.NonSharedProxy;
import immibis.core.net.IPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.EntityHuman;

public class PacketShowChunksResponse implements IPacket
{
    public Collection list = new LinkedList();

    public PacketShowChunksResponse() {}

    public PacketShowChunksResponse(EntityHuman var1)
    {
        Iterator var2 = Main.instance.getWorld(var1.world).getAllLoaders().iterator();

        while (var2.hasNext())
        {
            WorldInfo.LoaderInfo var3 = (WorldInfo.LoaderInfo)var2.next();

            if (var1.e((double)var3.pos.x, (double)var3.pos.y, (double)var3.pos.z) <= 65536.0D)
            {
                boolean var4 = var3.player.equals(var1.name);

                if (var4 || Main.instance.showOtherPlayersLoaders || NonSharedProxy.isOp(var1.name))
                {
                    Iterator var5 = var3.getLoadedChunks().iterator();

                    while (var5.hasNext())
                    {
                        ChunkCoordIntPair var6 = (ChunkCoordIntPair)var5.next();
                        LoadedChunkDisplay var7 = new LoadedChunkDisplay();
                        var7.chunkX = var6.x;
                        var7.chunkZ = var6.z;
                        var7.loaderX = var3.pos.x;
                        var7.loaderY = var3.pos.y;
                        var7.loaderZ = var3.pos.z;
                        var7.isOwned = var4;
                        this.list.add(var7);
                    }
                }
            }
        }
    }

    public byte getID()
    {
        return (byte)2;
    }

    public void read(DataInputStream var1) throws IOException
    {
        this.list.clear();
        int var2 = var1.readInt();

        for (int var3 = 0; var3 < var2; ++var3)
        {
            LoadedChunkDisplay var4 = new LoadedChunkDisplay();
            var4.chunkX = var1.readInt();
            var4.chunkZ = var1.readInt();
            var4.loaderX = var1.readByte() + (var4.chunkX << 4);
            var4.loaderY = var1.readByte() & 255;
            var4.loaderZ = var1.readByte() + (var4.chunkZ << 4);
            var4.isOwned = var1.readBoolean();
            this.list.add(var4);
        }
    }

    public void write(DataOutputStream var1) throws IOException
    {
        var1.writeInt(this.list.size());
        Iterator var2 = this.list.iterator();

        while (var2.hasNext())
        {
            LoadedChunkDisplay var3 = (LoadedChunkDisplay)var2.next();
            var1.writeInt(var3.chunkX);
            var1.writeInt(var3.chunkZ);
            var1.writeByte(var3.loaderX - (var3.chunkX << 4));
            var1.writeByte((byte)var3.loaderY);
            var1.writeByte(var3.loaderZ - (var3.chunkZ << 4));
            var1.writeBoolean(var3.isOwned);
        }
    }

    public void onReceived(EntityHuman var1) {}
}
