package immibis.chunkloader;

import immibis.core.net.AbstractContainerSyncPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketGUIUpdate extends AbstractContainerSyncPacket
{
    public String owner;
    public int curQuota;
    public int maxQuota;
    public int radius;
    public boolean amIOp;
    public boolean isServerOwned;

    public PacketGUIUpdate(String var1, int var2, int var3, int var4, boolean var5, boolean var6)
    {
        this.owner = var1;
        this.curQuota = var2;
        this.maxQuota = var3;
        this.radius = var4;
        this.amIOp = var5;
        this.isServerOwned = var6;
    }

    public byte getID()
    {
        return (byte)0;
    }

    public void read(DataInputStream var1) throws IOException
    {
        this.owner = var1.readUTF();
        this.curQuota = var1.readInt();
        this.maxQuota = var1.readInt();
        this.radius = var1.readInt();
        this.amIOp = var1.readBoolean();
        this.isServerOwned = var1.readBoolean();
    }

    public void write(DataOutputStream var1) throws IOException
    {
        var1.writeUTF(this.owner);
        var1.writeInt(this.curQuota);
        var1.writeInt(this.maxQuota);
        var1.writeInt(this.radius);
        var1.writeBoolean(this.amIOp);
        var1.writeBoolean(this.isServerOwned);
    }
}
