package immibis.chunkloader;

import immibis.core.NonSharedProxy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class Logging
{
    public static PrintWriter logFile = null;
    public static File listFile = null;
    public static String listName = null;
    private static boolean logDirty = true;
    private static DateFormat tsFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void openLog(String var0)
    {
        listName = var0;

        try
        {
            logFile = new PrintWriter(new FileWriter(new File(NonSharedProxy.getMinecraftDir(), var0), true));
            log("Log opened");
        }
        catch (IOException var2)
        {
            throw new RuntimeException("Error opening chunk loader log file " + var0, var2);
        }
    }

    public static void setList(String var0)
    {
        listFile = new File(NonSharedProxy.getMinecraftDir(), var0);
    }

    public static void flushLog()
    {
        if (logDirty)
        {
            logDirty = false;

            if (logFile != null)
            {
                logFile.flush();
            }

            if (listFile != null)
            {
                try
                {
                    PrintWriter var0 = new PrintWriter(new FileWriter(listFile));
                    Iterator var1 = Main.allWorlds().iterator();

                    while (var1.hasNext())
                    {
                        WorldInfo var2 = (WorldInfo)var1.next();
                        var0.println("In " + var2.getName() + ":");
                        Iterator var3 = var2.getAllLoaders().iterator();

                        while (var3.hasNext())
                        {
                            WorldInfo.LoaderInfo var4 = (WorldInfo.LoaderInfo)var3.next();
                            var0.println("  At " + var4.pos + ": " + var4.getLogString());
                        }
                    }

                    var0.close();
                }
                catch (IOException var5)
                {
                    (new RuntimeException("Error writing chunk loader list file " + listName, var5)).printStackTrace();
                }
            }
        }
    }

    private static void log(String var0)
    {
        if (logFile != null)
        {
            logFile.println("[" + getTimestamp() + "] " + var0);
        }

        logDirty = true;
    }

    private static void writeLog(String var0, WorldInfo.LoaderInfo var1, String var2)
    {
        log("Loader " + var0 + (var2 != null ? " by " + var2 : "") + " at " + var1.pos + " in " + var1.world.getName() + ", " + var1.getLogString());
    }

    public static void onAdded(WorldInfo.LoaderInfo var0, String var1)
    {
        writeLog("added", var0, var1);
    }

    public static void onChanged(WorldInfo.LoaderInfo var0, String var1)
    {
        writeLog("updated", var0, var1);
    }

    public static void onRemoved(WorldInfo.LoaderInfo var0, String var1)
    {
        writeLog("removed", var0, var1);
    }

    public static void onUnloadWorld(WorldInfo var0)
    {
        log("Unloaded world info for " + var0.getName());
    }

    public static void onLoadWorld(WorldInfo var0)
    {
        log("Loaded world info for " + var0.getName());
    }

    public static String getTimestamp()
    {
        return tsFormat.format(new Date());
    }

    public static void onValidated(WorldInfo.LoaderInfo var0, String var1)
    {
        writeLog("validated", var0, (String)null);
    }

    public static void onInvalidated(WorldInfo.LoaderInfo var0, String var1)
    {
        writeLog("invalidated/removed", var0, (String)null);
    }
}
