package mffs;

import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;

public class TileEntityTubeProjektor extends TileEntityProjektor
{
    private int length = 1;
    private int maxlength;
    private int radius = 2;
    private int maxradius;
    private short mode_designe;
    private boolean inhiitor = true;

    public TileEntityTubeProjektor()
    {
        this.maxlength = mod_ModularForceFieldSystem.maxSize;
        this.maxradius = mod_ModularForceFieldSystem.maxTubeRadius;
        this.mode_designe = 1;
    }

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (!this.getActive() && this.getRadius() < this.getMaxradius())
                    {
                        this.setRadius(this.getRadius() + 1);
                    }

                    break;

                case 1:
                    if (!this.getActive() && this.getRadius() > 2)
                    {
                        this.setRadius(this.getRadius() - 1);
                    }

                    break;

                case 2:
                    if (!this.getActive() && this.getlength() < this.getMaxlength())
                    {
                        this.setlength(this.getlength() + 1);
                    }

                    break;

                case 3:
                    if (!this.getActive() && this.getlength() > 1)
                    {
                        this.setlength(this.getlength() - 1);
                    }

                    break;

                case 4:
                    if (!this.getActive() && this.getmode_designe() < 2)
                    {
                        this.setmode_designe((short)(this.getmode_designe() + 1));
                    }

                    break;

                case 5:
                    if (!this.getActive() && this.getmode_designe() > 1)
                    {
                        this.setmode_designe((short)(this.getmode_designe() - 1));
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.length = var1.getInt("length");
        this.radius = var1.getInt("radius");
        this.mode_designe = var1.getShort("mode_designe");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("length", this.length);
        var1.setInt("radius", this.radius);
        var1.setShort("mode_designe", this.mode_designe);
    }

    public int getMaxlength()
    {
        return this.maxlength;
    }

    public int getlength()
    {
        return this.length;
    }

    public int getRadius()
    {
        return this.radius;
    }

    public int getMaxradius()
    {
        return this.maxradius;
    }

    public void setRadius(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public void setRadiusinit(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public void setlength(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public void setlengthinit(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public short getmode_designe()
    {
        return this.mode_designe;
    }

    public void setmode_designe(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public void setmode_designeinit(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public boolean wrenchCanSetFacing(EntityHuman var1, int var2)
    {
        if (this.getFacing() != var2 && !this.getActive())
        {
            this.setFacing((short)var2);
            this.world.notify(this.x, this.y, this.z);
            return true;
        }
        else
        {
            return false;
        }
    }

    protected void getFieldShape(CoordinateList var1)
    {
        boolean var2 = false;
        boolean var3 = false;
        boolean var4 = false;
        int var5 = 0;
        int var6 = 0;
        int var7 = 0;
        int var8 = 0;
        int var9 = 0;
        int var10 = 0;
        int var11 = 0;
        byte var12 = 0;
        int var13 = 0;

        if (this.getFacing() == 0 || this.getFacing() == 1)
        {
            var6 = this.length;
            var5 = this.radius;
            var7 = this.radius;

            if (this.mode_designe == 2 && this.getFacing() == 0)
            {
                var9 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 1)
            {
                var9 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 0)
            {
                var9 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 1)
            {
                var9 = this.length;
            }
        }

        if (this.getFacing() == 2 || this.getFacing() == 3)
        {
            var6 = this.radius;
            var7 = this.length;
            var5 = this.radius;

            if (this.mode_designe == 2 && this.getFacing() == 3)
            {
                var10 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 2)
            {
                var10 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 3)
            {
                var13 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 2)
            {
                var13 = this.length;
            }
        }

        if (this.getFacing() == 4 || this.getFacing() == 5)
        {
            var6 = this.radius;
            var7 = this.radius;
            var5 = this.length;

            if (this.mode_designe == 2 && this.getFacing() == 5)
            {
                var8 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 4)
            {
                var8 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 5)
            {
                var11 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 4)
            {
                var11 = this.length;
            }
        }

        for (int var14 = 0 - var7 + var10; var14 <= var7 - var13; ++var14)
        {
            for (int var15 = 0 - var5 + var8; var15 <= var5 - var11; ++var15)
            {
                for (int var16 = 0 - var6 + var9; var16 <= var6 - var12; ++var16)
                {
                    if (var16 >= 0 || !this.isDome())
                    {
                        int var17 = var5;
                        int var18 = var6;
                        int var19 = var7;

                        if (var5 == this.length && (this.getFacing() == 4 || this.getFacing() == 5))
                        {
                            var17 = var5 + 1;
                        }

                        if (var6 == this.length && (this.getFacing() == 0 || this.getFacing() == 1))
                        {
                            var18 = var6 + 1;
                        }

                        if (var7 == this.length && (this.getFacing() == 2 || this.getFacing() == 3))
                        {
                            var19 = var7 + 1;
                        }

                        if (var15 != 0 - var17 && var15 != var17 && var16 != 0 - var18 && var16 != var18 && var14 != 0 - var19 && var14 != var19)
                        {
                            var1.add(var15 + this.x, var16 + this.y, var14 + this.z, 2);
                        }
                        else
                        {
                            var1.add(var15 + this.x, var16 + this.y, var14 + this.z);
                        }
                    }
                }
            }
        }
    }

    public void onActivateProjector()
    {
        boolean var1 = false;
        boolean var2 = false;
        boolean var3 = false;
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        int var7 = 0;
        int var8 = 0;
        int var9 = 0;
        int var10 = 0;
        byte var11 = 0;
        int var12 = 0;

        if (this.getFacing() == 0 || this.getFacing() == 1)
        {
            var5 = this.length;
            var4 = this.radius;
            var6 = this.radius;

            if (this.mode_designe == 2 && this.getFacing() == 0)
            {
                var8 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 1)
            {
                var8 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 0)
            {
                var8 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 1)
            {
                var8 = this.length;
            }
        }

        if (this.getFacing() == 2 || this.getFacing() == 3)
        {
            var5 = this.radius;
            var6 = this.length;
            var4 = this.radius;

            if (this.mode_designe == 2 && this.getFacing() == 3)
            {
                var9 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 2)
            {
                var9 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 3)
            {
                var12 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 2)
            {
                var12 = this.length;
            }
        }

        if (this.getFacing() == 4 || this.getFacing() == 5)
        {
            var5 = this.radius;
            var6 = this.radius;
            var4 = this.length;

            if (this.mode_designe == 2 && this.getFacing() == 5)
            {
                var7 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 4)
            {
                var7 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 5)
            {
                var10 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 4)
            {
                var10 = this.length;
            }
        }

        for (int var13 = 0 - var6 + var9; var13 <= var6 - var12; ++var13)
        {
            for (int var14 = 0 - var4 + var7; var14 <= var4 - var10; ++var14)
            {
                for (int var15 = 0 - var5 + var8; var15 <= var5 - var11; ++var15)
                {
                    if (var15 >= 0 || !this.isDome())
                    {
                        int var16 = var4;
                        int var17 = var5;
                        int var18 = var6;

                        if (var4 == this.length && (this.getFacing() == 4 || this.getFacing() == 5))
                        {
                            var16 = var4 + 1;
                        }

                        if (var5 == this.length && (this.getFacing() == 0 || this.getFacing() == 1))
                        {
                            var17 = var5 + 1;
                        }

                        if (var6 == this.length && (this.getFacing() == 2 || this.getFacing() == 3))
                        {
                            var18 = var6 + 1;
                        }

                        if (var14 != 0 - var16 && var14 != var16 && var15 != 0 - var17 && var15 != var17 && var13 != 0 - var18 && var13 != var18 && this.isSubwater() && this.world.getMaterial(this.x + var14, this.y + var15, this.z + var13).isLiquid())
                        {
                            this.world.setTypeId(this.x + var14, this.y + var15, this.z + var13, 0);
                        }
                    }
                }
            }
        }
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int[] getUpdate()
    {
        return new int[] {this.length, this.maxlength, this.radius, this.maxradius, this.mode_designe, this.inhiitor ? 1 : 0};
    }

    public void handleUpdate(int[] var1)
    {
        this.length = var1[0];
        this.maxlength = var1[1];
        this.radius = var1[2];
        this.maxradius = var1[3];
        this.mode_designe = (short)var1[4];
        this.inhiitor = var1[5] != 0;
    }

    public int estimateBlockCount()
    {
        return (this.radius * 2 + 1) * (this.isDome() ? 2 : 4) * this.length * (this.mode_designe == 2 ? 1 : 2);
    }
}
