/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.Item;

public class WM_WeaponStorage {
    public final boolean isIndependant;
    public final boolean isEntity;
    public final boolean useMaterials;
    public final String weaponName;
    public final int networkID;
    public Item weaponItem;
    public int entityID;
    public boolean isEnabled;
    private int itemID;
    private Map itemIDsWithMaterial;
    public static final String[] materials = new String[]{"wood", "stone", "iron", "diamond", "gold"};
    public static Map propsMap = new HashMap();
    private static int registeredWeaponAmount = 0;

    private WM_WeaponStorage(String string, boolean bl, boolean bl2, boolean bl3) {
        this.weaponName = string;
        this.isEntity = bl2;
        this.useMaterials = bl;
        this.isIndependant = bl3;
        this.networkID = this.isEntity ? ++registeredWeaponAmount : 0;
        if (this.useMaterials) {
            this.itemIDsWithMaterial = new HashMap();
        }
    }

    public void setItemID(int n) {
        if (this.useMaterials) {
            throw new IllegalStateException("Weapon uses materials. Use setItemIDs instead.");
        }
        this.itemID = n;
    }

    public int getItemID() {
        if (this.useMaterials) {
            throw new IllegalStateException("Weapon uses materials. Use getItemIDs instead.");
        }
        return this.itemID;
    }

    public void setItemIDs(int[] nArray) {
        if (!this.useMaterials) {
            throw new IllegalStateException("Weapon does not use materials. Use setItemID instead.");
        }
        for (int i = 0; i < materials.length; ++i) {
            this.itemIDsWithMaterial.put(materials[i], nArray[i]);
        }
    }

    public int[] getItemIDs() {
        if (!this.useMaterials) {
            throw new IllegalStateException("Weapon does not use materials. Use getItemID instead.");
        }
        int[] nArray = new int[materials.length];
        for (int i = 0; i < materials.length; ++i) {
            try {
                nArray[i] = (Integer)this.itemIDsWithMaterial.get(materials[i]);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                nArray[i] = 0;
            }
        }
        return nArray;
    }

    public static void clear() {
        WM_WeaponStorage[] wM_WeaponStorageArray;
        for (WM_WeaponStorage wM_WeaponStorage : wM_WeaponStorageArray = propsMap.values().toArray(new WM_WeaponStorage[0])) {
            if (!wM_WeaponStorage.useMaterials) continue;
            wM_WeaponStorage.itemIDsWithMaterial.clear();
        }
        propsMap.clear();
    }

    public static boolean isEnabled(String string) {
        return WM_WeaponStorage.getWeapon((String)string).isEnabled;
    }

    public static void addWeapon(String string, boolean bl, boolean bl2, boolean bl3) {
        propsMap.put(string, new WM_WeaponStorage(string, bl, bl2, bl3));
    }

    public static WM_WeaponStorage getWeapon(String string) {
        return (WM_WeaponStorage)propsMap.get(string);
    }
}

