/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.EntityHuman;

public class WM_WarhammerCharge {
    private int chargeDelay;
    private long lastAttack;
    public EntityHuman entityPlayer;
    private static Map chargeMap = new HashMap();
    public static final int DEFAULT_CHARGE_DELAY = 30000;

    private WM_WarhammerCharge(EntityHuman entityHuman) {
        this.entityPlayer = entityHuman;
        this.resetCharge(30000);
    }

    public void resetCharge(int n) {
        this.chargeDelay = n;
        this.lastAttack = 0L;
    }

    public boolean isCharged() {
        return System.currentTimeMillis() - this.lastAttack > (long)this.chargeDelay;
    }

    public void onAttack() {
        this.lastAttack = System.currentTimeMillis();
    }

    public static WM_WarhammerCharge getWarhammerCharge(EntityHuman entityHuman) {
        WM_WarhammerCharge wM_WarhammerCharge = (WM_WarhammerCharge)chargeMap.get(entityHuman);
        if (wM_WarhammerCharge == null) {
            wM_WarhammerCharge = WM_WarhammerCharge.registerPlayerToCharge(entityHuman);
        }
        return wM_WarhammerCharge;
    }

    public static WM_WarhammerCharge registerPlayerToCharge(EntityHuman entityHuman) {
        WM_WarhammerCharge wM_WarhammerCharge = new WM_WarhammerCharge(entityHuman);
        chargeMap.put(entityHuman, wM_WarhammerCharge);
        return wM_WarhammerCharge;
    }
}

