/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumToolMaterial;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.WM_EntityMusketBullet;
import net.minecraft.server.WM_EnumWeapon;
import net.minecraft.server.WM_ItemReloadable;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_ItemMusket
extends WM_ItemReloadable {
    public WM_ItemMusket(int n, EnumToolMaterial enumToolMaterial, WM_EnumWeapon wM_EnumWeapon) {
        super(n, enumToolMaterial, wM_EnumWeapon, 2);
        if (wM_EnumWeapon == WM_EnumWeapon.KNIFE) {
            this.setMaxDurability(this.getMaxDurability() * 2);
        }
    }

    @Override
    protected void onReloadClick(int n, ItemStack itemStack, World world, EntityHuman entityHuman) {
        if (n == this.reloadClicks) {
            entityHuman.C_();
            world.makeSound((Entity)entityHuman, "random.click", 1.0f, 1.0f / (Item.c.nextFloat() * 0.4f + 0.8f));
        } else if (n == 1) {
            world.makeSound((Entity)entityHuman, "note.hat", 2.0f, Item.c.nextFloat() * 0.4f + 0.4f);
        }
    }

    @Override
    public int getReloadClickDelay(int n, ItemStack itemStack) {
        return 20;
    }

    @Override
    public void fire(ItemStack itemStack, World world, EntityHuman entityHuman, int n) {
        int n2 = this.c(itemStack) - n;
        float f = (float)n2 / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        f /= 3.0f;
        f += 0.02f;
        if (!world.isStatic) {
            WM_EntityMusketBullet wM_EntityMusketBullet = new WM_EntityMusketBullet(world, (EntityLiving)entityHuman, 1.0f / f);
            world.addEntity((Entity)wM_EntityMusketBullet);
        }
        int n3 = 4;
        if (itemStack.getData() + n3 <= itemStack.i()) {
            this.postShootingEffects(itemStack, entityHuman, world, entityHuman.isSneaking());
            this.resetReload(itemStack);
        }
        itemStack.damage(n3, (EntityLiving)entityHuman);
    }

    @Override
    public int getAmmoItemId() {
        return mod_WeaponMod.musketBullet.id;
    }

    @Override
    protected void postShootingEffects(ItemStack itemStack, EntityHuman entityHuman, World world, boolean bl) {
        world.makeSound((Entity)entityHuman, "random.explode", 3.0f, 1.0f / (Item.c.nextFloat() * 0.4f + 0.7f));
        world.makeSound((Entity)entityHuman, "ambient.weather.thunder", 3.0f, 1.0f / (Item.c.nextFloat() * 0.4f + 0.4f));
        float f = bl ? -0.05f : -0.1f;
        double d = -MathHelper.sin((float)(entityHuman.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)0.0f) * f;
        double d2 = MathHelper.cos((float)(entityHuman.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)0.0f) * f;
        entityHuman.pitch = entityHuman.pitch - (bl ? 7.5f : 15.0f);
        entityHuman.b_(d, 0.0, d2);
        float f2 = -MathHelper.sin((float)((entityHuman.yaw + 23.0f) / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entityHuman.pitch / 180.0f * (float)Math.PI));
        float f3 = -MathHelper.sin((float)(entityHuman.pitch / 180.0f * (float)Math.PI)) - 0.1f;
        float f4 = MathHelper.cos((float)((entityHuman.yaw + 23.0f) / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entityHuman.pitch / 180.0f * (float)Math.PI));
        for (int i = 0; i < 3; ++i) {
            world.a("smoke", entityHuman.locX + (double)f2, entityHuman.locY + (double)f3, entityHuman.locZ + (double)f4, 0.0, 0.0, 0.0);
        }
        world.a("flame", entityHuman.locX + (double)f2, entityHuman.locY + (double)f3, entityHuman.locZ + (double)f4, 0.0, 0.0, 0.0);
    }
}

