/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumToolMaterial;
import net.minecraft.server.ItemStack;
import net.minecraft.server.WM_EntityCrossbowBolt;
import net.minecraft.server.WM_EnumWeapon;
import net.minecraft.server.WM_ItemReloadable;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_ItemCrossbow
extends WM_ItemReloadable {
    public int overrideIDloaded;
    public int overrideIDunloaded;

    public WM_ItemCrossbow(int n, EnumToolMaterial enumToolMaterial, WM_EnumWeapon wM_EnumWeapon, int n2, int n3) {
        super(n, enumToolMaterial, wM_EnumWeapon, 1);
        this.overrideIDloaded = n2;
        this.overrideIDunloaded = n3;
    }

    @Override
    protected void onReloadClick(int n, ItemStack itemStack, World world, EntityHuman entityHuman) {
        if (n == this.reloadClicks) {
            entityHuman.C_();
            world.makeSound((Entity)entityHuman, "random.click", 0.8f, 1.0f / (c.nextFloat() * 0.4f + 0.4f));
            this.d(this.overrideIDloaded);
        }
    }

    @Override
    public int getReloadClickDelay(int n, ItemStack itemStack) {
        return 20;
    }

    @Override
    public void fire(ItemStack itemStack, World world, EntityHuman entityHuman, int n) {
        int n2 = this.c(itemStack) - n;
        float f = (float)n2 / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        f /= 3.0f;
        WM_EntityCrossbowBolt wM_EntityCrossbowBolt = new WM_EntityCrossbowBolt(world, (EntityLiving)entityHuman, 0.5f / (f += 0.02f));
        if (entityHuman.abilities.canInstantlyBuild) {
            wM_EntityCrossbowBolt.doesArrowBelongToPlayer = false;
        }
        if (!world.isStatic) {
            world.addEntity((Entity)wM_EntityCrossbowBolt);
        }
        this.postShootingEffects(itemStack, entityHuman, world, entityHuman.isSneaking());
        this.resetReload(itemStack);
    }

    @Override
    public void resetReload(ItemStack itemStack) {
        super.resetReload(itemStack);
        this.d(this.overrideIDunloaded);
    }

    @Override
    public int getAmmoItemId() {
        return mod_WeaponMod.bolt.id;
    }

    @Override
    protected void postShootingEffects(ItemStack itemStack, EntityHuman entityHuman, World world, boolean bl) {
        world.makeSound((Entity)entityHuman, "random.bow", 1.0f, 1.0f / (c.nextFloat() * 0.4f + 0.8f));
        entityHuman.pitch = entityHuman.pitch - (bl ? 4.0f : 8.0f);
    }
}

