/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumToolMaterial;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.WM_EntityBlunderShot;
import net.minecraft.server.WM_EnumWeapon;
import net.minecraft.server.WM_ItemReloadable;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_ItemBlunderbuss
extends WM_ItemReloadable {
    public WM_ItemBlunderbuss(int n, EnumToolMaterial enumToolMaterial, WM_EnumWeapon wM_EnumWeapon) {
        super(n, enumToolMaterial, wM_EnumWeapon, 1);
    }

    @Override
    protected void onReloadClick(int n, ItemStack itemStack, World world, EntityHuman entityHuman) {
        if (n == this.reloadClicks) {
            entityHuman.C_();
            world.makeSound((Entity)entityHuman, "random.door_close", 0.8f, 1.0f / (c.nextFloat() * 0.2f + 0.0f));
        }
    }

    @Override
    public int getReloadClickDelay(int n, ItemStack itemStack) {
        return 20;
    }

    @Override
    public void fire(ItemStack itemStack, World world, EntityHuman entityHuman, int n) {
        if (!world.isStatic) {
            WM_EntityBlunderShot.fireSpreadShot(world, (EntityLiving)entityHuman);
        }
        int n2 = 4;
        if (itemStack.getData() + n2 <= itemStack.i()) {
            this.postShootingEffects(itemStack, entityHuman, world, entityHuman.isSneaking());
            this.resetReload(itemStack);
        }
        itemStack.damage(n2, (EntityLiving)entityHuman);
    }

    @Override
    public int getAmmoItemId() {
        return mod_WeaponMod.blunderShot.id;
    }

    @Override
    protected void postShootingEffects(ItemStack itemStack, EntityHuman entityHuman, World world, boolean bl) {
        world.makeSound((Entity)entityHuman, "random.old_explode", 3.0f, 1.0f / (c.nextFloat() * 0.4f + 1.0f));
        float f = bl ? -0.1f : -0.2f;
        double d = -MathHelper.sin((float)(entityHuman.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)0.0f) * f;
        double d2 = MathHelper.cos((float)(entityHuman.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)0.0f) * f;
        entityHuman.pitch = entityHuman.pitch - (bl ? 17.5f : 25.0f);
        entityHuman.b_(d, 0.0, d2);
        float f2 = -MathHelper.sin((float)((entityHuman.yaw + 23.0f) / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entityHuman.pitch / 180.0f * (float)Math.PI));
        float f3 = -MathHelper.sin((float)(entityHuman.pitch / 180.0f * (float)Math.PI)) - 0.1f;
        float f4 = MathHelper.cos((float)((entityHuman.yaw + 23.0f) / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entityHuman.pitch / 180.0f * (float)Math.PI));
        for (int i = 0; i < 3; ++i) {
            world.a("smoke", entityHuman.locX + (double)f2, entityHuman.locY + (double)f3, entityHuman.locZ + (double)f4, 0.0, 0.0, 0.0);
        }
        world.a("flame", entityHuman.locX + (double)f2, entityHuman.locY + (double)f3, entityHuman.locZ + (double)f4, 0.0, 0.0, 0.0);
    }
}

