/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumToolMaterial;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.WM_EntityBlowgunDart;
import net.minecraft.server.WM_EnumWeapon;
import net.minecraft.server.WM_ItemReloadable;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_ItemBlowgun
extends WM_ItemReloadable {
    public WM_ItemBlowgun(int n, EnumToolMaterial enumToolMaterial, WM_EnumWeapon wM_EnumWeapon) {
        super(n, enumToolMaterial, wM_EnumWeapon, 1);
    }

    @Override
    protected void onReloadClick(int n, ItemStack itemStack, World world, EntityHuman entityHuman) {
        if (n == this.reloadClicks) {
            entityHuman.C_();
            world.makeSound((Entity)entityHuman, "random.click", 0.8f, 1.0f / (c.nextFloat() * 0.4f + 0.4f));
        }
    }

    @Override
    public int getReloadClickDelay(int n, ItemStack itemStack) {
        return 10;
    }

    @Override
    public void fire(ItemStack itemStack, World world, EntityHuman entityHuman, int n) {
        int n2 = this.c(itemStack) - n;
        float f = (float)n2 / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) < 0.1f) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        WM_EntityBlowgunDart wM_EntityBlowgunDart = new WM_EntityBlowgunDart(world, (EntityLiving)entityHuman, f * 1.5f);
        if (entityHuman.abilities.canInstantlyBuild) {
            wM_EntityBlowgunDart.doesArrowBelongToPlayer = false;
        }
        if (!world.isStatic) {
            world.addEntity((Entity)wM_EntityBlowgunDart);
        }
        this.postShootingEffects(itemStack, entityHuman, world, entityHuman.isSneaking());
        this.resetReload(itemStack);
    }

    @Override
    public void playEmptySound(ItemStack itemStack, World world, EntityHuman entityHuman) {
        world.makeSound((Entity)entityHuman, "random.bow", 1.0f, 1.0f / (c.nextFloat() * 0.2f + 0.5f));
    }

    @Override
    public void playChargeSound(ItemStack itemStack, World world, EntityHuman entityHuman) {
        world.makeSound((Entity)entityHuman, "random.breath", 1.0f, 1.0f / (c.nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public int getAmmoItemId() {
        return mod_WeaponMod.dart.id;
    }

    @Override
    protected void postShootingEffects(ItemStack itemStack, EntityHuman entityHuman, World world, boolean bl) {
        world.makeSound((Entity)entityHuman, "random.bow", 1.0f, 1.0f / (c.nextFloat() * 0.2f + 0.5f));
        float f = -MathHelper.sin((float)((entityHuman.yaw + 23.0f) / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entityHuman.pitch / 180.0f * (float)Math.PI));
        float f2 = -MathHelper.sin((float)(entityHuman.pitch / 180.0f * (float)Math.PI)) - 0.1f;
        float f3 = MathHelper.cos((float)((entityHuman.yaw + 23.0f) / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entityHuman.pitch / 180.0f * (float)Math.PI));
        world.a("explode", entityHuman.locX + (double)f, entityHuman.locY + (double)f2, entityHuman.locZ + (double)f3, 0.0, 0.0, 0.0);
    }
}

