/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.WM_EntityProjectile;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;

public class WM_EntitySpear
extends WM_EntityProjectile {
    public ItemStack thrownItem;
    public boolean beenInTile;

    public WM_EntitySpear(World world) {
        super(world);
    }

    public WM_EntitySpear(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
    }

    public WM_EntitySpear(World world, EntityLiving entityLiving, ItemStack itemStack) {
        this(world);
        this.thrownItem = itemStack;
        this.shootingEntity = entityLiving;
        this.doesArrowBelongToPlayer = entityLiving instanceof EntityHuman;
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.locY -= 0.1;
        this.locZ -= (double)(MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motZ = MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motY = -MathHelper.sin((float)(this.pitch / 180.0f * (float)Math.PI));
        this.setArrowHeading(this.motX, this.motY, this.motZ, 0.6f, 3.0f);
    }

    @Override
    protected void b() {
    }

    @Override
    public void F_() {
        super.F_();
    }

    @Override
    public void onEntityHit(Entity entity) {
        if (this.world.isStatic) {
            return;
        }
        DamageSource damageSource = null;
        damageSource = this.shootingEntity == null ? WM_WeaponDamageSource.causeWeaponDamage(this, this) : WM_WeaponDamageSource.causeWeaponDamage(this, this.shootingEntity);
        if (entity.damageEntity(damageSource, this.thrownItem.a(entity))) {
            this.playHitSound();
            if (this.thrownItem.getData() + 1 > this.thrownItem.i()) {
                --this.thrownItem.count;
                this.die();
            } else {
                this.thrownItem.damage(1, null);
                this.setVelocity(0.2 * this.random.nextDouble() - 0.1, 0.2 * this.random.nextDouble() - 0.1, 0.2 * this.random.nextDouble() - 0.1);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void playHitSound() {
        this.world.makeSound((Entity)this, "random.bowhit", 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public int getMaxArrowShake() {
        return 10;
    }

    @Override
    public ItemStack getPickupItem() {
        return this.thrownItem;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.thrownItem != null) {
            nBTTagCompound.setCompound("thrownItem", this.thrownItem.save(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.thrownItem = ItemStack.a((NBTTagCompound)nBTTagCompound.getCompound("thrownItem"));
    }
}

