/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class WM_EntityProjectile
extends Entity {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected int inTile = 0;
    protected int inData = 0;
    protected boolean inGround = false;
    public boolean doesArrowBelongToPlayer = false;
    public int arrowShake = 0;
    public Entity shootingEntity;
    protected int ticksInGround;
    protected int ticksInAir = 0;
    public boolean beenInGround;
    public boolean isCritical = false;

    public WM_EntityProjectile(World world) {
        super(world);
        this.height = 0.0f;
        this.b(0.5f, 0.5f);
    }

    protected void b() {
    }

    public void setArrowHeading(double d, double d2, double d3, float f, float f2) {
        float f3 = MathHelper.sqrt((double)(d * d + d2 * d2 + d3 * d3));
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * 0.0075 * (double)f2;
        d2 += this.random.nextGaussian() * 0.0075 * (double)f2;
        d3 += this.random.nextGaussian() * 0.0075 * (double)f2;
        this.motX = d *= (double)f;
        this.motY = d2 *= (double)f;
        this.motZ = d3 *= (double)f;
        float f4 = MathHelper.sqrt((double)(d * d + d3 * d3));
        this.lastYaw = this.yaw = (float)(Math.atan2(d, d3) * 180.0 / Math.PI);
        this.lastPitch = this.pitch = (float)(Math.atan2(d2, f4) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void setVelocity(double d, double d2, double d3) {
        this.motX = d;
        this.motY = d2;
        this.motZ = d3;
        if (this.lastPitch == 0.0f && this.lastYaw == 0.0f) {
            if (this.aimRotation()) {
                float f = MathHelper.sqrt((double)(d * d + d3 * d3));
                this.lastYaw = this.yaw = (float)(Math.atan2(d, d3) * 180.0 / Math.PI);
                this.lastPitch = this.pitch = (float)(Math.atan2(d2, f) * 180.0 / Math.PI);
                this.lastPitch = this.pitch;
                this.lastYaw = this.yaw;
            }
            this.setPositionRotation(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
            this.ticksInGround = 0;
        }
    }

    public void F_() {
        int n;
        Vec3D vec3D;
        int n2;
        super.F_();
        if (this.aimRotation() && this.lastPitch == 0.0f && this.lastYaw == 0.0f) {
            float f = MathHelper.sqrt((double)(this.motX * this.motX + this.motZ * this.motZ));
            this.lastYaw = this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / Math.PI);
            this.lastPitch = this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / Math.PI);
        }
        if ((n2 = this.world.getTypeId(this.xTile, this.yTile, this.zTile)) > 0) {
            Block.byId[n2].updateShape((IBlockAccess)this.world, this.xTile, this.yTile, this.zTile);
            vec3D = Block.byId[n2].e(this.world, this.xTile, this.yTile, this.zTile);
            if (vec3D != null && vec3D.a(Vec3D.create((double)this.locX, (double)this.locY, (double)this.locZ))) {
                this.inGround = true;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            int n3 = this.world.getTypeId(this.xTile, this.yTile, this.zTile);
            int n4 = this.world.getData(this.xTile, this.yTile, this.zTile);
            if (n3 != this.inTile || n4 != this.inData) {
                this.inGround = false;
                this.motX *= (double)(this.random.nextFloat() * 0.2f);
                this.motY *= (double)(this.random.nextFloat() * 0.2f);
                this.motZ *= (double)(this.random.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInGround;
                if (this.ticksInGround >= (this.doesArrowBelongToPlayer ? 200 : 800)) {
                    this.die();
                }
            }
            return;
        }
        ++this.ticksInAir;
        vec3D = Vec3D.create((double)this.locX, (double)this.locY, (double)this.locZ);
        Vec3D vec3D2 = Vec3D.create((double)(this.locX + this.motX), (double)(this.locY + this.motY), (double)(this.locZ + this.motZ));
        MovingObjectPosition movingObjectPosition = this.world.rayTrace(vec3D, vec3D2, false, true);
        vec3D = Vec3D.create((double)this.locX, (double)this.locY, (double)this.locZ);
        vec3D2 = Vec3D.create((double)(this.locX + this.motX), (double)(this.locY + this.motY), (double)(this.locZ + this.motZ));
        if (movingObjectPosition != null) {
            vec3D2 = Vec3D.create((double)movingObjectPosition.pos.a, (double)movingObjectPosition.pos.b, (double)movingObjectPosition.pos.c);
        }
        Entity entity = null;
        List list = this.world.getEntities((Entity)this, this.boundingBox.a(this.motX, this.motY, this.motZ).grow(1.0, 1.0, 1.0));
        double d = 0.0;
        for (n = 0; n < list.size(); ++n) {
            double d2;
            float f;
            AxisAlignedBB axisAlignedBB;
            MovingObjectPosition movingObjectPosition2;
            Entity entity2 = (Entity)list.get(n);
            if (!entity2.o_() || entity2 == this.shootingEntity && this.ticksInAir < 5 || (movingObjectPosition2 = (axisAlignedBB = entity2.boundingBox.grow((double)(f = 0.3f), (double)f, (double)f)).a(vec3D, vec3D2)) == null || !((d2 = vec3D.b(movingObjectPosition2.pos)) < d) && d != 0.0) continue;
            entity = entity2;
            d = d2;
        }
        if (entity != null) {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
        if (movingObjectPosition != null) {
            if (movingObjectPosition.entity != null) {
                this.onEntityHit(movingObjectPosition.entity);
            } else {
                this.onGroundHit(movingObjectPosition);
            }
        }
        if (this.isCritical) {
            for (n = 0; n < 2; ++n) {
                this.world.a("crit", this.locX + this.motX * (double)n / 4.0, this.locY + this.motY * (double)n / 4.0, this.locZ + this.motZ * (double)n / 4.0, -this.motX, -this.motY + 0.2, -this.motZ);
            }
        }
        this.locX += this.motX;
        this.locY += this.motY;
        this.locZ += this.motZ;
        if (this.aimRotation()) {
            float f = MathHelper.sqrt((double)(this.motX * this.motX + this.motZ * this.motZ));
            this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / Math.PI);
            this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / Math.PI);
            while (this.pitch - this.lastPitch < -180.0f) {
                this.lastPitch -= 360.0f;
            }
            while (this.pitch - this.lastPitch >= 180.0f) {
                this.lastPitch += 360.0f;
            }
            while (this.yaw - this.lastYaw < -180.0f) {
                this.lastYaw -= 360.0f;
            }
            while (this.yaw - this.lastYaw >= 180.0f) {
                this.lastYaw += 360.0f;
            }
            this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
            this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
        }
        float f = this.getAirResistance();
        float f2 = this.getGravity();
        if (this.aU()) {
            this.beenInGround = true;
            for (int i = 0; i < 4; ++i) {
                float f3 = 0.25f;
                this.world.a("bubble", this.locX - this.motX * (double)f3, this.locY - this.motY * (double)f3, this.locZ - this.motZ * (double)f3, this.motX, this.motY, this.motZ);
            }
            f = 0.8f;
        }
        this.motX *= (double)f;
        this.motY *= (double)f;
        this.motZ *= (double)f;
        this.motY -= (double)f2;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    public final double getTotalVelocity() {
        return Math.sqrt(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
    }

    public boolean aimRotation() {
        return true;
    }

    public void onEntityHit(Entity entity) {
        this.bounceBack();
    }

    public void onGroundHit(MovingObjectPosition movingObjectPosition) {
        this.xTile = movingObjectPosition.b;
        this.yTile = movingObjectPosition.c;
        this.zTile = movingObjectPosition.d;
        this.inTile = this.world.getTypeId(this.xTile, this.yTile, this.zTile);
        this.inData = this.world.getData(this.xTile, this.yTile, this.zTile);
        this.motX = (float)(movingObjectPosition.pos.a - this.locX);
        this.motY = (float)(movingObjectPosition.pos.b - this.locY);
        this.motZ = (float)(movingObjectPosition.pos.c - this.locZ);
        float f = MathHelper.sqrt((double)(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ));
        this.locX -= this.motX / (double)f * 0.05;
        this.locY -= this.motY / (double)f * 0.05;
        this.locZ -= this.motZ / (double)f * 0.05;
        this.inGround = true;
        this.beenInGround = true;
        this.isCritical = false;
        this.arrowShake = this.getMaxArrowShake();
        this.playHitSound();
    }

    protected void bounceBack() {
        this.motX *= -0.1;
        this.motY *= -0.1;
        this.motZ *= -0.1;
        this.yaw += 180.0f;
        this.lastYaw += 180.0f;
        this.ticksInAir = 0;
    }

    public ItemStack getPickupItem() {
        return null;
    }

    public float getAirResistance() {
        return 0.99f;
    }

    public float getGravity() {
        return 0.05f;
    }

    public int getMaxArrowShake() {
        return 7;
    }

    public void playHitSound() {
    }

    public void a_(EntityHuman entityHuman) {
        if (this.world.isStatic) {
            return;
        }
        ItemStack itemStack = this.getPickupItem();
        if (itemStack == null) {
            return;
        }
        if (this.inGround && this.doesArrowBelongToPlayer && this.arrowShake <= 0 && entityHuman.inventory.pickup(itemStack)) {
            this.world.makeSound((Entity)this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityHuman.receive((Entity)this, 1);
            this.die();
        }
    }

    public float getShadowSize() {
        return 0.0f;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("xTile", (short)this.xTile);
        nBTTagCompound.setShort("yTile", (short)this.yTile);
        nBTTagCompound.setShort("zTile", (short)this.zTile);
        nBTTagCompound.setByte("inTile", (byte)this.inTile);
        nBTTagCompound.setByte("inData", (byte)this.inData);
        nBTTagCompound.setByte("shake", (byte)this.arrowShake);
        nBTTagCompound.setBoolean("inGround", this.inGround);
        nBTTagCompound.setBoolean("player", this.doesArrowBelongToPlayer);
        nBTTagCompound.setBoolean("crit", this.isCritical);
        nBTTagCompound.setBoolean("beenInGround", this.beenInGround);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.xTile = nBTTagCompound.getShort("xTile");
        this.yTile = nBTTagCompound.getShort("yTile");
        this.zTile = nBTTagCompound.getShort("zTile");
        this.inTile = nBTTagCompound.getByte("inTile") & 0xFF;
        this.inData = nBTTagCompound.getByte("inData") & 0xFF;
        this.arrowShake = nBTTagCompound.getByte("shake") & 0xFF;
        this.inGround = nBTTagCompound.getBoolean("inGround");
        this.doesArrowBelongToPlayer = nBTTagCompound.getBoolean("player");
        this.isCritical = nBTTagCompound.getBoolean("crit");
        this.beenInGround = nBTTagCompound.getBoolean("beenInGrond");
    }
}

