/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.WM_EntityProjectile;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;

public class WM_EntityMusketBullet
extends WM_EntityProjectile {
    public WM_EntityMusketBullet(World world) {
        super(world);
    }

    public WM_EntityMusketBullet(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
    }

    public WM_EntityMusketBullet(World world, EntityLiving entityLiving, float f) {
        this(world);
        this.shootingEntity = entityLiving;
        this.doesArrowBelongToPlayer = entityLiving instanceof EntityHuman;
        this.b(0.5f, 0.5f);
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.locY -= 0.1;
        this.locZ -= (double)(MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motZ = MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motY = -MathHelper.sin((float)(this.pitch / 180.0f * (float)Math.PI));
        this.setArrowHeading(this.motX, this.motY, this.motZ, 5.0f, f);
    }

    @Override
    public void F_() {
        super.F_();
        if (this.inGround) {
            if (this.random.nextInt(4) == 0) {
                this.world.a("smoke", this.locX, this.locY, this.locZ, 0.0, 0.0, 0.0);
            }
            return;
        }
        double d = this.getTotalVelocity();
        double d2 = 16.0;
        if (d > 2.0) {
            int n = 1;
            while ((double)n < d2) {
                this.world.a("explode", this.locX + this.motX * (double)n / d2, this.locY + this.motY * (double)n / d2, this.locZ + this.motZ * (double)n / d2, 0.0, 0.0, 0.0);
                ++n;
            }
        }
    }

    @Override
    public void onEntityHit(Entity entity) {
        int n = 25 - this.ticksInAir;
        if (n < 1) {
            n = 1;
        }
        DamageSource damageSource = null;
        damageSource = this.shootingEntity == null ? WM_WeaponDamageSource.causeWeaponDamage(this, this) : WM_WeaponDamageSource.causeWeaponDamage(this, this.shootingEntity);
        entity.damageEntity(damageSource, n);
        this.die();
    }

    @Override
    public void onGroundHit(MovingObjectPosition movingObjectPosition) {
        this.xTile = movingObjectPosition.b;
        this.yTile = movingObjectPosition.c;
        this.zTile = movingObjectPosition.d;
        this.inTile = this.world.getTypeId(this.xTile, this.yTile, this.zTile);
        this.inData = this.world.getData(this.xTile, this.yTile, this.zTile);
        Material material = this.world.getMaterial(this.xTile, this.yTile, this.zTile);
        boolean bl = material.equals(Material.STONE);
        boolean bl2 = material.equals(Material.ORE);
        if (this.ticksInAir > 0 && (bl || bl2)) {
            if (bl2) {
                this.locX = this.xTile;
                this.locY = this.yTile;
                this.locZ = this.zTile;
                if (movingObjectPosition.face == 0 || movingObjectPosition.face == 1) {
                    this.motY *= -1.0;
                } else if (movingObjectPosition.face == 2 || movingObjectPosition.face == 3) {
                    this.motZ *= -1.0;
                } else if (movingObjectPosition.face == 4 || movingObjectPosition.face == 5) {
                    this.motX *= -1.0;
                }
                this.motX *= (double)0.6f;
                this.motY *= (double)0.6f;
                this.motZ *= (double)0.6f;
            } else if (bl) {
                this.motX *= (double)(0.5f - this.random.nextFloat());
                this.motY *= (double)(0.5f - this.random.nextFloat());
                this.motZ *= (double)(0.5f - this.random.nextFloat());
            }
            this.world.makeSound((double)this.xTile, (double)this.yTile, (double)this.zTile, "note.hat", 2.0f, this.random.nextFloat() * 0.4f + 0.4f);
        } else {
            this.motX = (float)(movingObjectPosition.pos.a - this.locX);
            this.motY = (float)(movingObjectPosition.pos.b - this.locY);
            this.motZ = (float)(movingObjectPosition.pos.c - this.locZ);
            float f = MathHelper.sqrt((double)(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ));
            this.locX -= this.motX / (double)f * 0.05;
            this.locY -= this.motY / (double)f * 0.05;
            this.locZ -= this.motZ / (double)f * 0.05;
            this.inGround = true;
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public float getGravity() {
        return this.getTotalVelocity() >= 3.0 ? 0.0f : 0.07f;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }
}

