/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.WM_EntityProjectile;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;

public class WM_EntityKnife
extends WM_EntityProjectile {
    protected ItemStack thrownItem;
    private int soundTimer;

    public WM_EntityKnife(World world) {
        super(world);
    }

    public WM_EntityKnife(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
    }

    public WM_EntityKnife(World world, EntityLiving entityLiving, ItemStack itemStack) {
        this(world);
        this.thrownItem = itemStack;
        this.shootingEntity = entityLiving;
        this.doesArrowBelongToPlayer = entityLiving instanceof EntityHuman;
        this.soundTimer = 0;
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.locY -= 0.1;
        this.locZ -= (double)(MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motZ = MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motY = -MathHelper.sin((float)(this.pitch / 180.0f * (float)Math.PI));
        this.setArrowHeading(this.motX, this.motY, this.motZ, 0.8f, 3.0f);
    }

    @Override
    public void F_() {
        super.F_();
        if (this.inGround || this.beenInGround) {
            return;
        }
        this.pitch -= 70.0f;
        if (this.soundTimer >= 3) {
            if (!this.a(Material.WATER)) {
                this.world.makeSound((Entity)this, "random.bow", 0.6f, 1.0f / (this.random.nextFloat() * 0.2f + 0.6f + (float)this.ticksInAir / 15.0f));
            }
            this.soundTimer = 0;
        }
        ++this.soundTimer;
    }

    @Override
    public void onEntityHit(Entity entity) {
        if (this.world.isStatic) {
            return;
        }
        DamageSource damageSource = null;
        damageSource = this.shootingEntity == null ? WM_WeaponDamageSource.causeWeaponDamage(this, this) : WM_WeaponDamageSource.causeWeaponDamage(this, this.shootingEntity);
        if (entity.damageEntity(damageSource, this.thrownItem.a(entity))) {
            if (this.thrownItem.getData() + 2 > this.thrownItem.i()) {
                --this.thrownItem.count;
                this.die();
            } else {
                this.thrownItem.damage(2, null);
                this.setVelocity(0.2 * this.random.nextDouble() - 0.1, 0.2 * this.random.nextDouble() - 0.1, 0.2 * this.random.nextDouble() - 0.1);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public boolean aimRotation() {
        return this.beenInGround;
    }

    @Override
    public int getMaxArrowShake() {
        return 4;
    }

    @Override
    public float getGravity() {
        return 0.03f;
    }

    @Override
    public ItemStack getPickupItem() {
        return this.thrownItem;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.thrownItem != null) {
            nBTTagCompound.setCompound("thrownItem", this.thrownItem.save(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.thrownItem = ItemStack.a((NBTTagCompound)nBTTagCompound.getCompound("thrownItem"));
    }
}

