/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.WM_EntityProjectile;
import net.minecraft.server.WM_PhysHelper;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_EntityDynamite
extends WM_EntityProjectile {
    private int explodefuse = this.random.nextInt(30) + 20;
    private boolean extinguished = false;

    public WM_EntityDynamite(World world) {
        super(world);
    }

    public WM_EntityDynamite(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
    }

    public WM_EntityDynamite(World world, EntityLiving entityLiving, int n) {
        this(world);
        this.shootingEntity = entityLiving;
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.locY -= 0.1;
        this.locZ -= (double)(MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.motX = -MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motZ = MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motY = -MathHelper.sin((float)(this.pitch / 180.0f * (float)Math.PI));
        this.setArrowHeading(this.motX, this.motY, this.motZ, 0.7f, 4.0f);
        this.explodefuse = n;
    }

    @Override
    protected void b() {
    }

    @Override
    public void F_() {
        super.F_();
        this.pitch = !this.onGround && !this.beenInGround ? (this.pitch -= 50.0f) : 180.0f;
        if (this.aU() && !this.extinguished) {
            this.extinguished = true;
            this.world.makeSound((Entity)this, "random.fizz", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            for (int i = 0; i < 8; ++i) {
                float f = 0.25f;
                this.world.a("explode", this.locX - this.motX * (double)f, this.locY - this.motY * (double)f, this.locZ - this.motZ * (double)f, this.motX, this.motY, this.motZ);
            }
        }
        --this.explodefuse;
        if (!this.extinguished) {
            if (this.explodefuse <= 0) {
                this.detonate();
                this.die();
            } else if (this.explodefuse > 0) {
                this.world.a("smoke", this.locX, this.locY, this.locZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void onEntityHit(Entity entity) {
        DamageSource damageSource = null;
        damageSource = this.shootingEntity == null ? WM_WeaponDamageSource.causeWeaponDamage(this, this) : WM_WeaponDamageSource.causeWeaponDamage(this, this.shootingEntity);
        entity.damageEntity(damageSource, 2);
        this.world.makeSound((Entity)this, "random.fizz", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.ticksInAir = 0;
        this.setVelocity(this.motX * this.random.nextDouble(), this.motY * this.random.nextDouble(), this.motZ * this.random.nextDouble());
    }

    @Override
    public void onGroundHit(MovingObjectPosition movingObjectPosition) {
        this.xTile = movingObjectPosition.b;
        this.yTile = movingObjectPosition.c;
        this.zTile = movingObjectPosition.d;
        this.inTile = this.world.getTypeId(this.xTile, this.yTile, this.zTile);
        this.motX = (float)(movingObjectPosition.pos.a - this.locX);
        this.motY = (float)(movingObjectPosition.pos.b - this.locY);
        this.motZ = (float)(movingObjectPosition.pos.c - this.locZ);
        float f = MathHelper.sqrt((double)(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ));
        this.locX -= this.motX / (double)f * 0.05;
        this.locY -= this.motY / (double)f * 0.05;
        this.locZ -= this.motZ / (double)f * 0.05;
        this.motX *= -0.2;
        this.motZ *= -0.2;
        if (movingObjectPosition.face == 1) {
            this.inGround = true;
            this.beenInGround = true;
        } else {
            this.inGround = false;
            this.world.makeSound((Entity)this, "random.fizz", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        }
    }

    private void detonate() {
        if (this.world.isStatic) {
            return;
        }
        if (this.extinguished && (this.ticksInGround >= 200 || this.ticksInAir >= 200)) {
            this.die();
        }
        float f = 2.0f;
        if (mod_WeaponMod.instance.properties.dynamiteDoesBlockDamage) {
            this.world.explode((Entity)this, this.locX, this.locY, this.locZ, f);
        } else {
            WM_PhysHelper.createAdvancedExplosion(this.world, this, this.locX, this.locY, this.locZ, f, false, false, true);
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public ItemStack getPickupItem() {
        return new ItemStack(mod_WeaponMod.dynamite, 1);
    }

    @Override
    public float getShadowSize() {
        return 0.2f;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setByte("fuse", (byte)this.explodefuse);
        nBTTagCompound.setBoolean("off", this.extinguished);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.explodefuse = nBTTagCompound.getByte("fuse");
        this.extinguished = nBTTagCompound.getBoolean("off");
    }
}

