/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityDamageSource;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemBow;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemSword;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.WM_ItemWeaponMod;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_EntityDummy
extends Entity {
    private int durability;
    public int dummyCurrentDamage = 0;
    public int dummyTimeSinceHit = 0;
    public int dummyRockDirection = 1;

    public WM_EntityDummy(World world) {
        super(world);
        this.bf = true;
        this.pitch = -20.0f;
        this.c(this.yaw, this.pitch);
        this.b(1.5f, 1.9f);
        this.height = 0.41f;
        this.durability = 50;
    }

    public WM_EntityDummy(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2 + (double)this.height, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    protected void b() {
    }

    public AxisAlignedBB b_(Entity entity) {
        return entity.boundingBox;
    }

    public AxisAlignedBB h() {
        return this.boundingBox;
    }

    public boolean e_() {
        return false;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.world.isStatic || this.dead || n <= 0) {
            return false;
        }
        this.dummyRockDirection = -this.dummyRockDirection;
        this.dummyTimeSinceHit = 10;
        this.dummyCurrentDamage += n * 5;
        if (this.dummyCurrentDamage > 50) {
            this.dummyCurrentDamage = 50;
        }
        if (!(damageSource instanceof EntityDamageSource)) {
            this.durability -= n;
        } else if (damageSource instanceof WM_WeaponDamageSource) {
            Entity entity = ((WM_WeaponDamageSource)damageSource).getProjectile();
            if (Math.sqrt(entity.motX * entity.motX + entity.motY * entity.motY + entity.motZ * entity.motZ) > 0.5) {
                entity.motX *= (double)0.1f;
                entity.motY *= (double)0.1f;
                entity.motZ *= (double)0.1f;
                this.playRandomHitSound();
            } else {
                entity.motX = this.random.nextFloat() - 0.5f;
                entity.motY = this.random.nextFloat() - 0.5f;
                entity.motZ = this.random.nextFloat() - 0.5f;
            }
        } else {
            this.playRandomHitSound();
        }
        if (this.durability <= 0) {
            this.dropAsItem(true);
        }
        this.aW();
        return false;
    }

    public void playRandomHitSound() {
        int n = this.random.nextInt(2);
        if (n == 0) {
            this.world.makeSound((Entity)this, "step.cloth", 0.7f, 1.0f / this.random.nextFloat() * 0.2f + 0.4f);
        } else if (n == 1) {
            this.world.makeSound((Entity)this, "step.wood", 0.7f, 1.0f / this.random.nextFloat() * 0.2f + 0.2f);
        }
    }

    public void performHurtAnimation() {
        this.dummyRockDirection = -this.dummyRockDirection;
        this.dummyTimeSinceHit = 10;
        this.dummyCurrentDamage += this.dummyCurrentDamage * 10;
    }

    public boolean o_() {
        return !this.dead;
    }

    public void F_() {
        int n;
        super.F_();
        if (this.dummyTimeSinceHit > 0) {
            --this.dummyTimeSinceHit;
        }
        if (this.dummyCurrentDamage > 0) {
            --this.dummyCurrentDamage;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        if (this.onGround) {
            this.motX = 0.0;
            this.motY = 0.0;
            this.motZ = 0.0;
        } else {
            this.motX *= 0.99;
            this.motZ *= 0.99;
            this.motY -= 0.05;
            this.fallDistance = (float)((double)this.fallDistance + -this.motY);
        }
        this.c(this.yaw, this.pitch);
        this.move(0.0, this.motY, 0.0);
        List list = this.world.getEntities((Entity)this, this.boundingBox.grow(0.2, 0.0, 0.2));
        if (list != null && list.size() > 0) {
            for (n = 0; n < list.size(); ++n) {
                Entity entity = (Entity)list.get(n);
                if (entity == this.passenger || !entity.e_()) continue;
                entity.collide((Entity)this);
            }
        }
        for (n = 0; n < 4; ++n) {
            int n2;
            int n3;
            int n4 = MathHelper.floor((double)(this.locX + ((double)(n % 2) - 0.5) * 0.8));
            if (this.world.getTypeId(n4, n3 = MathHelper.floor((double)this.locY), n2 = MathHelper.floor((double)(this.locZ + ((double)(n / 2) - 0.5) * 0.8))) != Block.SNOW.id) continue;
            this.world.setTypeId(n4, n3, n2, 0);
        }
    }

    protected void a(float f) {
        super.a(f);
        if (!this.onGround) {
            return;
        }
        int n = MathHelper.d((float)f);
        this.damageEntity(DamageSource.FALL, n);
    }

    public void dropAsItem(boolean bl) {
        if (this.world.isStatic) {
            return;
        }
        if (bl) {
            for (int i = 0; i < this.random.nextInt(8); ++i) {
                this.a(Item.LEATHER.id, 1, 0.0f);
            }
        } else {
            this.a(mod_WeaponMod.dummy.id, 1, 0.0f);
        }
        this.die();
    }

    public boolean b(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack == null) {
            this.dropAsItem(false);
            return true;
        }
        if (!(itemStack.getItem() instanceof WM_ItemWeaponMod || itemStack.getItem() instanceof ItemSword || itemStack.getItem() instanceof ItemBow)) {
            this.dropAsItem(false);
            return true;
        }
        return false;
    }

    protected void b(NBTTagCompound nBTTagCompound) {
    }

    protected void a(NBTTagCompound nBTTagCompound) {
        this.setPosition(this.locX, this.locY, this.locZ);
        this.c(this.yaw, this.pitch);
    }
}

