/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.WM_EntityProjectile;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_EntityCrossbowBolt
extends WM_EntityProjectile {
    public WM_EntityCrossbowBolt(World world) {
        super(world);
    }

    public WM_EntityCrossbowBolt(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
    }

    public WM_EntityCrossbowBolt(World world, EntityLiving entityLiving, float f) {
        this(world);
        this.shootingEntity = entityLiving;
        this.doesArrowBelongToPlayer = entityLiving instanceof EntityHuman;
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.locY -= 0.1;
        this.locZ -= (double)(MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motZ = MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motY = -MathHelper.sin((float)(this.pitch / 180.0f * (float)Math.PI));
        this.setArrowHeading(this.motX, this.motY, this.motZ, 4.0f, f);
    }

    @Override
    protected void b() {
    }

    @Override
    public void F_() {
        super.F_();
    }

    @Override
    public void onEntityHit(Entity entity) {
        float f = MathHelper.sqrt((double)(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ));
        int n = (int)Math.ceil((double)f * 4.0);
        DamageSource damageSource = null;
        damageSource = this.shootingEntity == null ? WM_WeaponDamageSource.causeWeaponDamage(this, this) : WM_WeaponDamageSource.causeWeaponDamage(this, this.shootingEntity);
        if (entity.damageEntity(damageSource, n)) {
            if (entity instanceof EntityLiving) {
                ++((EntityLiving)entity).aI;
            }
            this.playHitSound();
            this.die();
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void playHitSound() {
        this.world.makeSound((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.4f));
    }

    @Override
    public int getMaxArrowShake() {
        return 4;
    }

    @Override
    public ItemStack getPickupItem() {
        return new ItemStack(mod_WeaponMod.bolt, 1);
    }
}

